/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.item;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lotr.client.LOTRClientProxy;
import lotr.common.item.LOTRItemDagger5;
import lotr.common.item.LOTRItemLance;
import lotr.common.item.LOTRItemPike;
import lotr.common.item.LOTRItemSpear;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class LOTRRenderLargeItem
implements IItemRenderer {
    private static Map<String, Float> sizeFolders = new HashMap<String, Float>();
    private final Item theItem;
    private final String folderName;
    private final float largeIconScale;
    private IIcon largeIcon;
    private List<ExtraLargeIconToken> extraTokens = new ArrayList<ExtraLargeIconToken>();

    private static ResourceLocation getLargeTexturePath(Item item, String folder) {
        String prefix = "lotr:";
        String itemName = item.func_77658_a();
        itemName = itemName.substring(itemName.indexOf(prefix) + prefix.length());
        String s = prefix + "textures/items/" + folder + "/" + itemName;
        s = s + ".png";
        return new ResourceLocation(s);
    }

    public static LOTRRenderLargeItem getRendererIfLarge(Item item) {
        for (String folder : sizeFolders.keySet()) {
            float iconScale = sizeFolders.get(folder).floatValue();
            try {
                ResourceLocation resLoc = LOTRRenderLargeItem.getLargeTexturePath(item, folder);
                IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(resLoc);
                if (res == null) continue;
                return new LOTRRenderLargeItem(item, folder, iconScale);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public LOTRRenderLargeItem(Item item, String dir, float f) {
        this.theItem = item;
        this.folderName = dir;
        this.largeIconScale = f;
    }

    public ExtraLargeIconToken extraIcon(String name) {
        ExtraLargeIconToken token = new ExtraLargeIconToken(name);
        this.extraTokens.add(token);
        return token;
    }

    public void registerIcons(IIconRegister register) {
        this.largeIcon = this.registerLargeIcon(register, null);
        for (ExtraLargeIconToken token : this.extraTokens) {
            token.icon = this.registerLargeIcon(register, token.name);
        }
    }

    private IIcon registerLargeIcon(IIconRegister register, String extra) {
        String prefix = "lotr:";
        String itemName = this.theItem.func_77658_a();
        itemName = itemName.substring(itemName.indexOf(prefix) + prefix.length());
        String path = prefix + this.folderName + "/" + itemName;
        if (!StringUtils.func_151246_b((String)extra)) {
            path = path + "_" + extra;
        }
        return register.func_94245_a(path);
    }

    private void doTransformations() {
        GL11.glTranslatef((float)(-(this.largeIconScale - 1.0f) / 2.0f), (float)(-(this.largeIconScale - 1.0f) / 2.0f), (float)0.0f);
        GL11.glScalef((float)this.largeIconScale, (float)this.largeIconScale, (float)1.0f);
    }

    public void renderLargeItem() {
        this.renderLargeItem(this.largeIcon);
    }

    public void renderLargeItem(ExtraLargeIconToken token) {
        this.renderLargeItem(token.icon);
    }

    private void renderLargeItem(IIcon icon) {
        this.doTransformations();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110576_c);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tess = Tessellator.field_78398_a;
        ItemRenderer.func_78439_a((Tessellator)tess, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
    }

    public boolean handleRenderType(ItemStack itemstack, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack itemstack, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemstack, Object ... data) {
        EntityLivingBase entityliving;
        GL11.glPushMatrix();
        Entity holder = (Entity)data[1];
        boolean isFirstPerson = holder == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
        Item item = itemstack.func_77973_b();
        if (item instanceof LOTRItemSpear && holder instanceof EntityPlayer && ((EntityPlayer)holder).func_71011_bu() == itemstack) {
            GL11.glRotatef((float)260.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
        }
        if (item instanceof LOTRItemPike && holder instanceof EntityLivingBase && (entityliving = (EntityLivingBase)holder).func_70694_bm() == itemstack && entityliving.field_70733_aJ <= 0.0f) {
            if (entityliving.func_70093_af()) {
                if (isFirstPerson) {
                    GL11.glRotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
                } else {
                    GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
                    GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            } else if (!isFirstPerson) {
                GL11.glTranslatef((float)0.0f, (float)-0.3f, (float)0.0f);
                GL11.glRotatef((float)40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        if (item instanceof LOTRItemDagger5 && holder instanceof EntityLivingBase && (entityliving = (EntityLivingBase)holder).func_70694_bm() == itemstack && entityliving.field_70733_aJ <= 0.0f) {
            if (entityliving.func_70093_af()) {
                if (isFirstPerson) {
                    GL11.glRotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
                } else {
                    GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
                    GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            } else if (!isFirstPerson) {
                GL11.glTranslatef((float)0.0f, (float)-0.3f, (float)0.0f);
                GL11.glRotatef((float)40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        if (item instanceof LOTRItemLance && holder instanceof EntityLivingBase && (entityliving = (EntityLivingBase)holder).func_70694_bm() == itemstack) {
            if (isFirstPerson) {
                GL11.glRotatef((float)260.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
            } else {
                GL11.glTranslatef((float)0.7f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-30.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
            }
        }
        this.renderLargeItem();
        if (itemstack != null && itemstack.hasEffect(0)) {
            LOTRClientProxy.renderEnchantmentEffect();
        }
        GL11.glPopMatrix();
    }

    static {
        sizeFolders.put("large", Float.valueOf(2.0f));
        sizeFolders.put("large1", Float.valueOf(2.35f));
        sizeFolders.put("large2", Float.valueOf(3.0f));
    }

    public static class ExtraLargeIconToken {
        public String name;
        public IIcon icon;

        public ExtraLargeIconToken(String s) {
            this.name = s;
        }
    }
}

